<?php
/**
 * Review sync settings header template
 *
 * @package    MailChimp_WooCommerce
 * @subpackage MailChimp_WooCommerce/admin
 */
?>

<div class="mc-wc-header-content review-sync-settings">
    <div class="mc-wc-header-content-wrapper">
        <div class="mc-wc-header-content-details">
            <h2 class="mc-wc-title"><?php esc_html_e('Review your sync settings', 'mailchimp-for-woocommerce'); ?></h2>
        </div>
        <div class="mc-wc-header-content-image">
            <div class="mc-wc-image">
                <img src="<?php echo esc_attr( plugin_dir_url( __FILE__ ) . '../../assets/images/Mailchimp-Woocommerce.png' ); ?>" alt="<?php esc_html_e( 'Mailchimp Woocommerce', 'mailchimp-for-woocommerce' ); ?>">
            </div>
        </div>
    </div>
    <div class="mc-wc-header-account">
        <div class="mc-wc-header-account-wrapper">
            <div class="mc-wc-header-account-logos">
                <div class="mc-wc-header-account-logo-image">
                    <svg width="91" height="27" viewBox="0 0 91 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M17.7661 12.7245C17.9399 12.7036 18.1064 12.7027 18.2584 12.7245C18.3467 12.5216 18.3621 12.1722 18.282 11.7909C18.1637 11.2249 18.0036 10.8827 17.6733 10.9355C17.3429 10.9892 17.3302 11.3987 17.4485 11.9647C17.5149 12.2832 17.6332 12.5553 17.7652 12.7236L17.7661 12.7245Z" fill="black"/>
                        <path d="M14.9267 13.1723C15.1633 13.276 15.3089 13.3452 15.3653 13.2851C15.4017 13.2478 15.3908 13.1759 15.3343 13.084C15.2179 12.8938 14.9776 12.7 14.7228 12.5917C14.2014 12.3669 13.5799 12.4415 13.1003 12.7864C12.942 12.902 12.7918 13.0631 12.8136 13.1604C12.8209 13.1923 12.8446 13.2159 12.9001 13.2232C13.0302 13.2378 13.487 13.0075 14.0121 12.9757C14.3834 12.9529 14.6901 13.0685 14.9267 13.1732V13.1723Z" fill="black"/>
                        <path d="M14.45 13.4434C14.1415 13.4917 13.9723 13.5936 13.8631 13.6882C13.7702 13.7692 13.712 13.8593 13.7129 13.923C13.7129 13.953 13.7266 13.9703 13.7366 13.9794C13.7502 13.9922 13.7675 13.9985 13.7875 13.9985C13.8567 13.9985 14.0132 13.9357 14.0132 13.9357C14.4418 13.7819 14.7248 13.8011 15.0051 13.8329C15.1598 13.8502 15.2335 13.8602 15.2672 13.8065C15.2772 13.791 15.289 13.7583 15.2581 13.7082C15.1862 13.5908 14.875 13.3934 14.45 13.4434Z" fill="black"/>
                        <path d="M16.8066 14.4408C17.0159 14.5436 17.2461 14.5036 17.3216 14.3507C17.3972 14.1978 17.288 13.9912 17.0787 13.8884C16.8694 13.7856 16.6391 13.8256 16.5636 13.9785C16.489 14.1314 16.5973 14.338 16.8066 14.4408Z" fill="black"/>
                        <path d="M18.1528 13.2651C17.9827 13.2623 17.8416 13.4489 17.838 13.6819C17.8343 13.9148 17.969 14.1059 18.1383 14.1096C18.3075 14.1132 18.4495 13.9257 18.4531 13.6928C18.4568 13.4598 18.3221 13.2687 18.1528 13.2651Z" fill="black"/>
                        <path d="M6.55387 17.4474C6.50655 17.4584 6.45377 17.4711 6.39553 17.4702C6.27086 17.4675 6.16439 17.4147 6.10524 17.3228C6.02789 17.2036 6.03244 17.0261 6.11798 16.8232C6.12981 16.7959 6.14346 16.7658 6.15802 16.7322C6.29452 16.4264 6.52293 15.9141 6.26631 15.4263C6.07339 15.0587 5.75944 14.8303 5.38088 14.782C5.01779 14.7356 4.64378 14.8703 4.40536 15.1333C4.02953 15.5483 3.97038 16.1125 4.04318 16.3127C4.06957 16.3855 4.11143 16.4064 4.14146 16.41C4.20516 16.4182 4.2998 16.3718 4.35895 16.2126C4.3635 16.2007 4.36896 16.1834 4.37624 16.1607C4.40263 16.0761 4.45177 15.9195 4.53276 15.794C4.63013 15.642 4.78119 15.5373 4.95864 15.5C5.13973 15.4609 5.32446 15.4955 5.47916 15.5974C5.74215 15.7694 5.84407 16.0924 5.73123 16.4009C5.67299 16.5602 5.57835 16.865 5.59928 17.1153C5.64114 17.6222 5.95327 17.8251 6.23264 17.8469C6.50473 17.8569 6.69492 17.7041 6.74315 17.593C6.77136 17.5266 6.7477 17.4866 6.73223 17.4693C6.69037 17.4165 6.6203 17.4329 6.55296 17.4483L6.55387 17.4474Z" fill="black"/>
                        <path d="M22.4414 16.542C22.4313 16.5056 22.3631 16.259 22.2712 15.9614C22.1784 15.6638 22.0828 15.4545 22.0828 15.4545C22.455 14.8976 22.4614 14.3998 22.4122 14.1177C22.3595 13.7683 22.2139 13.4698 21.9208 13.1622C21.6278 12.8547 21.0272 12.5389 20.1846 12.3023C20.0881 12.275 19.7705 12.1876 19.7423 12.1794C19.7405 12.1612 19.7186 11.1366 19.6995 10.6961C19.6859 10.3786 19.6586 9.8817 19.5039 9.39303C19.3201 8.73146 19.0006 8.15179 18.6012 7.78142C19.7032 6.63937 20.3911 5.38084 20.3893 4.30158C20.3866 2.22587 17.8368 1.59797 14.6954 2.89836C14.6918 2.90018 14.0348 3.17864 14.0302 3.18137C14.0275 3.17864 12.8272 2.0011 12.809 1.98472C9.22543 -1.13931 -1.97394 11.3086 1.60691 14.3316L2.38951 14.9941C2.18658 15.5201 2.1065 16.1225 2.17202 16.7704C2.25574 17.6021 2.68526 18.4002 3.3805 19.0163C4.04116 19.6014 4.9093 19.9718 5.75196 19.9709C7.14517 23.1813 10.3293 25.1515 14.0621 25.2625C18.0661 25.3817 21.4276 23.5026 22.8354 20.1274C22.9273 19.8908 23.3186 18.8234 23.3186 17.8815C23.3186 16.9397 22.7835 16.542 22.4423 16.542H22.4414ZM6.05863 19.0691C5.93669 19.09 5.81293 19.0982 5.68735 19.0954C4.47796 19.0627 3.1712 17.9743 3.04198 16.683C2.8982 15.2562 3.62802 14.1578 4.91931 13.8975C5.07401 13.8666 5.26056 13.8484 5.46167 13.8593C6.18512 13.8993 7.25073 14.4544 7.49461 16.0306C7.71028 17.4265 7.36812 18.847 6.05954 19.0709L6.05863 19.0691ZM4.70819 13.043C3.90466 13.1996 3.19577 13.6546 2.76261 14.2843C2.50326 14.0686 2.02096 13.65 1.93633 13.4871C1.24473 12.174 2.69072 9.62053 3.70173 8.17909C6.19877 4.61553 10.1099 1.91829 11.9208 2.40787C12.2148 2.49159 13.1903 3.62181 13.1903 3.62181C13.1903 3.62181 11.3803 4.62554 9.70227 6.02603C7.44092 7.76686 5.73285 10.2976 4.7091 13.0439L4.70819 13.043ZM9.32007 8.16453C10.2073 7.13896 11.3002 6.24716 12.2794 5.74575C12.3131 5.72846 12.3495 5.76486 12.3303 5.79853C12.253 5.93958 12.1028 6.24079 12.0555 6.4692C12.0482 6.50469 12.0874 6.53199 12.1174 6.51106C12.7262 6.0961 13.7863 5.65111 14.7155 5.59378C14.7555 5.59105 14.7746 5.64292 14.7428 5.66658C14.6017 5.77487 14.447 5.92502 14.3342 6.07699C14.3151 6.10247 14.3333 6.13978 14.3651 6.13978C15.0176 6.14433 15.9376 6.37274 16.5373 6.70944C16.5782 6.73219 16.5491 6.81045 16.5036 6.80044C15.5963 6.59205 14.1112 6.43462 12.5688 6.81136C11.1919 7.14715 10.1409 7.66585 9.37376 8.22368C9.33463 8.25189 9.28822 8.20093 9.32007 8.16453ZM22.4823 18.2009C22.3085 19.2547 21.8608 20.1092 21.1082 20.8963C20.6505 21.3896 20.0936 21.8182 19.4575 22.1303C19.1199 22.3077 18.7595 22.4615 18.38 22.5853C15.5426 23.5117 12.6388 22.4934 11.7034 20.3057C11.6287 20.141 11.565 19.969 11.5159 19.7889C11.1173 18.3474 11.4558 16.6175 12.5142 15.5292C12.5797 15.46 12.6461 15.3781 12.6461 15.2753C12.6461 15.1897 12.5915 15.0987 12.5442 15.0341C12.1738 14.4972 10.8907 13.5818 11.1483 11.81C11.333 10.5378 12.4459 9.64146 13.4842 9.69424C13.5716 9.69879 13.6599 9.70425 13.7472 9.70971C14.1968 9.7361 14.589 9.79434 14.9593 9.80981C15.579 9.8362 16.136 9.74611 16.7957 9.19647C17.0187 9.01083 17.197 8.84976 17.4991 8.7988C17.531 8.79334 17.6102 8.76513 17.7676 8.77241C17.9287 8.7806 18.0825 8.82519 18.2199 8.9171C18.7486 9.26927 18.8241 10.1219 18.8514 10.7453C18.8669 11.1011 18.9096 11.9629 18.9251 12.2104C18.9588 12.7755 19.1071 12.8556 19.4083 12.9548C19.5776 13.0103 19.7341 13.0521 19.9662 13.1167C20.6669 13.3133 21.0818 13.5126 21.343 13.7692C21.4995 13.9294 21.5714 14.0995 21.5941 14.2615C21.677 14.8639 21.1264 15.6083 19.6695 16.2845C18.077 17.0234 16.1451 17.2108 14.811 17.0616C14.7082 17.0498 14.3451 17.0088 14.3433 17.0088C13.2758 16.865 12.6661 18.2446 13.3077 19.1901C13.7208 19.7989 14.8456 20.1956 15.9713 20.1956C18.552 20.1956 20.5349 19.0936 21.2729 18.1427C21.2948 18.1145 21.2975 18.1108 21.3321 18.059C21.3685 18.0044 21.3384 17.9743 21.2929 18.0053C20.6905 18.4175 18.0124 20.0555 15.1486 19.5623C15.1486 19.5623 14.801 19.5049 14.4834 19.3812C14.2313 19.2829 13.7026 19.0399 13.638 18.4976C15.9494 19.2119 17.4045 18.5367 17.4045 18.5367C17.4309 18.5258 17.4491 18.4958 17.4455 18.4657C17.4418 18.4293 17.4091 18.402 17.3727 18.4057C17.3727 18.4057 15.478 18.6859 13.6881 18.0307C13.8828 17.3974 14.4015 17.6258 15.185 17.6895C16.5973 17.7732 17.8631 17.5676 18.7986 17.2991C19.6094 17.0661 20.6741 16.6075 21.5004 15.955C21.7789 16.5675 21.8781 17.2418 21.8781 17.2418C21.8781 17.2418 22.0937 17.2036 22.2739 17.3146C22.4441 17.4192 22.5697 17.6376 22.4841 18.2018L22.4823 18.2009ZM13.7418 18.1035C13.7418 18.1035 13.7418 18.1035 13.7418 18.1045C13.7418 18.1045 13.7418 18.1035 13.7418 18.1026V18.1035Z" fill="black"/>
                        <path d="M36.1825 14.6701C34.2988 14.6701 34.266 16.7267 33.8201 16.7267C33.7273 16.7267 33.6536 16.6448 33.6536 16.532C33.6536 16.3818 33.6927 16.2517 33.6927 16.0087C33.6927 15.2707 33.1731 14.6701 32.0838 14.6701C31.1593 14.6701 30.4822 15.1333 30.0691 15.9896C29.8598 16.4237 29.878 16.7258 29.666 16.7258C29.5877 16.7258 29.5267 16.6521 29.5267 16.5456C29.5267 16.2308 29.8043 15.9432 29.8043 15.2671C29.8043 15.0914 29.7906 14.9431 29.7624 14.8221H27.9697V21.769H30.4012V17.9998C30.4012 17.2572 30.7197 16.7813 31.263 16.7813C31.6234 16.7813 31.9437 17.0962 31.9437 17.6722V21.769H34.3752V17.9998C34.3752 17.1653 34.7611 16.7813 35.237 16.7813C35.6356 16.7813 35.9177 17.1498 35.9177 17.6722V21.769H38.321V17.5038C38.321 15.6402 37.5811 14.6692 36.1816 14.6692L36.1825 14.6701Z" fill="black"/>
                        <path d="M52.813 12.8783H50.4097V21.7699H52.813V12.8783Z" fill="black"/>
                        <path d="M53.6054 18.2137C53.6054 20.5769 55.1351 21.9374 57.1207 21.9374C58.2591 21.9374 59.1291 21.4869 59.6633 21.0483V18.756C59.1227 19.1255 58.291 19.5477 57.3983 19.5477C56.2844 19.5477 55.703 19.0854 55.703 18.2837C55.703 17.482 56.3736 17.0334 57.3564 17.0334C58.2464 17.0334 59.0627 17.3874 59.6624 17.7978V15.3663C59.1546 14.9886 58.2582 14.6574 57.1198 14.6574C54.9886 14.6574 53.6045 15.9896 53.6045 18.2146L53.6054 18.2137Z" fill="black"/>
                        <path d="M64.9566 14.6847C63.9792 14.6847 63.4132 15.1379 62.9973 15.9769C62.8144 16.3472 62.8008 16.7131 62.5942 16.7131C62.5169 16.7131 62.455 16.6412 62.455 16.5329C62.455 16.148 62.9136 15.5737 62.9136 13.8793C62.9136 13.4534 62.8718 13.1249 62.789 12.8929H60.6914V21.7708H63.1229V18.0317C63.1229 17.331 63.4915 16.7968 64.0539 16.7968C64.4725 16.7968 64.7627 17.1371 64.7627 17.6877V21.7708H67.1943V17.422C67.1943 15.6074 66.4026 14.6847 64.9575 14.6847H64.9566Z" fill="black"/>
                        <path d="M87.2699 14.6565C86.1951 14.6565 85.6464 15.2689 85.3397 15.8349C85.0968 16.2826 85.0613 16.7131 84.8529 16.7131C84.751 16.7131 84.7 16.653 84.7 16.5329C84.7 16.3199 84.9776 15.9587 84.9776 15.3663C84.9776 15.1251 84.9585 14.9449 84.9221 14.8248H83.1021V23.5499H85.5472V20.809C85.8575 21.4715 86.5073 21.9101 87.3954 21.9101C88.997 21.9101 90.0909 20.5888 90.0909 18.2837C90.0909 16.1571 89.0771 14.6574 87.2708 14.6574L87.2699 14.6565ZM86.6165 20.3112C86.126 20.3112 85.5882 19.8025 85.5882 18.5185C85.5882 17.4001 86.0277 16.7404 86.6165 16.7404C87.2935 16.7404 87.6721 17.3928 87.6721 18.5185C87.6721 19.7698 87.2362 20.3112 86.6165 20.3112Z" fill="black"/>
                        <path d="M42.6673 14.6565C41.4115 14.6565 40.2613 14.9668 39.4623 15.3644V17.3764C40.3923 16.8741 41.346 16.5019 42.1823 16.5019C43.0777 16.5019 43.4572 16.9742 43.4035 17.5958C43.0422 17.5584 42.6409 17.543 42.1541 17.543C40.2522 17.543 39.0601 18.2855 39.0601 19.9017C39.0601 21.2294 40.0938 21.9137 41.2249 21.9137C42.3561 21.9137 43.0877 21.3859 43.5272 20.5906C43.7775 20.1374 43.7566 19.8598 43.9195 19.8598C43.9995 19.8598 44.055 19.9172 44.055 20.0063C44.055 20.2966 43.9722 20.4659 43.9722 20.859C43.9722 21.2267 44.0205 21.5361 44.0969 21.7608H45.845V18.0417C45.845 15.9295 44.8786 14.6555 42.6673 14.6555V14.6565ZM41.8483 20.2065C41.3969 20.2065 41.1549 20.0091 41.1549 19.6651C41.1549 19.2174 41.5762 18.8743 42.6673 18.8743C42.9075 18.8743 43.125 18.8825 43.3225 18.8989C43.226 19.5386 42.6691 20.2065 41.8483 20.2065Z" fill="black"/>
                        <path d="M51.3359 8.27555V4.37802H49.6624V8.07626C49.6624 8.99263 49.0491 9.60506 48.2437 9.60506C47.4384 9.60506 46.8251 8.99172 46.8251 8.07626V4.37802H45.1543L45.1634 8.27555C45.1634 9.9727 46.522 11.2139 48.2483 11.2139C49.9746 11.2139 51.3359 9.97543 51.3359 8.27555Z" fill="black"/>
                        <path d="M57.7989 11.0793H59.4696V5.94322H61.4634V4.37802H55.8032V5.94322H57.7989V11.0793Z" fill="black"/>
                        <path d="M54.723 4.38074H53.0522V11.082H54.723V4.38074Z" fill="black"/>
                        <path d="M40.4077 11.0793H42.0784V5.94322H44.0713V4.37802H38.4111V5.94322H40.4077V11.0793Z" fill="black"/>
                        <path d="M29.6424 7.73227V4.38074H27.9717V11.082H29.6424V7.73227Z" fill="black"/>
                        <path d="M33.0286 7.38191C33.0286 6.46554 33.6419 5.85311 34.4473 5.85311C35.2526 5.85311 35.866 6.46645 35.866 7.38191V11.0802H37.5367L37.5322 7.18262C37.5322 5.48547 36.1708 4.24423 34.4446 4.24423C32.7183 4.24423 31.3569 5.48274 31.3569 7.18262V11.0802H33.0277V7.38191H33.0286Z" fill="black"/>
                        <path d="M79.9481 14.6701C78.0644 14.6701 78.0316 16.7267 77.5857 16.7267C77.4929 16.7267 77.4192 16.6448 77.4192 16.532C77.4192 16.3818 77.4583 16.2517 77.4583 16.0087C77.4583 15.2707 76.9387 14.6701 75.8495 14.6701C74.9249 14.6701 74.2479 15.1333 73.8347 15.9896C73.6254 16.4237 73.6436 16.7258 73.4316 16.7258C73.3533 16.7258 73.2924 16.6521 73.2924 16.5456C73.2924 16.2308 73.5699 15.9432 73.5699 15.2671C73.5699 15.0914 73.5563 14.9431 73.5281 14.8221H71.7354V21.769H74.1669V17.9998C74.1669 17.2572 74.4854 16.7813 75.0286 16.7813C75.389 16.7813 75.7093 17.0962 75.7093 17.6722V21.769H78.1408V17.9998C78.1408 17.1653 78.5267 16.7813 79.0026 16.7813C79.4012 16.7813 79.6833 17.1498 79.6833 17.6722V21.769H82.0866V17.5038C82.0866 15.6402 81.3468 14.6692 79.9472 14.6692L79.9481 14.6701Z" fill="black"/>
                        <path d="M69.4302 15.3098C68.9206 15.3098 68.5174 15.2361 68.2217 15.0878V21.7708H70.625V15.0878C70.3129 15.2252 69.9416 15.3098 69.4302 15.3098Z" fill="black"/>
                        <path d="M69.4166 12.8365C68.4229 12.8365 67.9023 13.276 67.9023 13.781C67.9023 14.3252 68.5184 14.7256 69.4166 14.7256C70.3148 14.7256 70.9308 14.3252 70.9308 13.781C70.9308 13.276 70.4094 12.8365 69.4166 12.8365Z" fill="black"/>
                        <path d="M48.1382 15.3098C47.6286 15.3098 47.2254 15.2361 46.9297 15.0878V21.7708H49.333V15.0878C49.0209 15.2252 48.6496 15.3098 48.1382 15.3098Z" fill="black"/>
                        <path d="M48.1246 12.8365C47.1309 12.8365 46.6104 13.276 46.6104 13.781C46.6104 14.3252 47.2264 14.7256 48.1246 14.7256C49.0228 14.7256 49.6388 14.3252 49.6388 13.781C49.6388 13.276 49.1174 12.8365 48.1246 12.8365Z" fill="black"/>
                    </svg>
                </div>
                <?php if ($account_name): ?>
                    <div class="mc-wc-header-account-logo-text">
                        <span class="account-name-text"><?php echo esc_attr($account_name); ?></span>
                        <span class="authorized-text"><?php echo __( 'Authorized', 'mailchimp-for-woocommerce' ); ?></span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="mc-wc-header-account-switch-account">
                <a href="?page=mailchimp-woocommerce&breadcrumb=connect_accounts" class="mc-wc-text-link"><?php esc_html_e('Switch account', 'mailchimp-for-woocommerce'); ?></a>
            </div>
        </div>
    </div>
    <div class="mc-wc-header-content-footer">
        <div class="mc-wc-header-content-footer-wrapper">
            <p class="mc-wc-descripition"><?php esc_html_e('Sync your store data using the default settings, or configure how your WooCommerce data will sync to Mailchimp.', 'mailchimp-for-woocommerce'); ?></p>
            <input type="submit" name="mailchimp_submit" class="mc-wc-btn mc-wc-btn-primary" value="<?php esc_html_e('Sync now', 'mailchimp-for-woocommerce'); ?>" />
        </div>
    </div>
</div>